/*************************************
*         Copyright 2015 EDF         *
*************************************/
#ifndef GLOBAL_H
#define GLOBAL_H
/**\file
\~french Fichier des dfinitions globale de PyCATSHOO. Il permet de grer de manire simple les diffrences entre les OS Windows, Linux et Mac OS.
\~english PyCATSHOO global definitions file. It allows to easily manage the differences between Windows, Linux and Mac OS.
*/

//Pour grer les fuites mmoire
#ifdef _DEBUG_NEW
#ifdef _INC_STDLIB
#pragma message("Impossible de grer les fuites mmoires car stdlib.h est dj inclus")
#endif
#define _CRTDBG_MAP_ALLOC
#include <stdlib.h>
#include <crtdbg.h>
#ifdef _DEBUG
   #ifndef DBG_NEW
      #define DBG_NEW new ( _NORMAL_BLOCK , __FILE__ , __LINE__ )
      #define new DBG_NEW
   #endif
#endif
#endif

#ifdef __GNUC__
#define DEPRECATED __attribute__ ((deprecated))
#elif defined(_MSC_VER)
#define DEPRECATED __declspec(deprecated)
#else
#pragma message("WARNING: You need to implement DEPRECATED for this compiler")
#define DEPRECATED
#endif

#include <stdlib.h>
#include <stdarg.h>

#define PYCATSHOO_NAME "Pycatshoo"

/*\~french Classe de dfinition d'un foncteur de comparaison d'adresses d'lments sur la base du comparateur par dfaut des lments.
Si l'une des adresses est NULL, l'oprateur compare directement les adresses.
\~english Class defining a functor for comparing element addresses based on the default comparator of elements.
If one of the addresses is NULL, the operator compares the addresses directly.*/
template<typename T>class CAddrComp{
public:
	bool operator()(T const*t1,T const*t2)const{return (t1&&t2)?(*t1)<(*t2):t1<t2;}//!<\~french \~french Oprateur de comparaison (infriorit) d'adresses\~english Address comparison (less than) operator\~english 
};
class CNamedComp;
typedef CAddrComp<CNamedComp> ncLess;
class IMonitored;
typedef CAddrComp<IMonitored> imLess;
class ITreeNode;
typedef CAddrComp<ITreeNode> tnLess;

typedef size_t SEQ_ID;
typedef unsigned int CNX_ID;
typedef CNX_ID LAWP_ID;//Pour l'instant les paramtres de loi sont stocks dans une rfrence
typedef unsigned int BEP_ID;
typedef unsigned int TGT_ID;
typedef unsigned int PRF_ID;

//Macro Definitions si ncessaire
#ifdef PYC_DLL_INTERNAL
	#define PYC_PUBLIC __declspec(dllexport)
	#define PYC_PRIVATE
	#define STD_EXT
#else
	#ifdef PYC_DLL
		#define PYC_PUBLIC __declspec(dllimport)
		#define PYC_PRIVATE
		#define STD_EXT extern
	#else
		#define PYC_PUBLIC
		#define PYC_PRIVATE
		#define STD_EXT
	#endif
#endif//#ifdef PYC_DLL_INTERNAL

typedef double PyTime;

/*\~french Structure de dfinition des instants de monitoring.
Les instants ne peuvent tre dfinis uniquement par leur date car les transitions peuvent avoir une dure nulle.
La structure contient donc un indice en plus de la date.
L'indice du premier accs  une date est 0. Puis l'indice est incrment tant qu'on ne change pas de date.
\~english Structure for defining monitoring instants.
Instants cannot be defined solely by their date because transitions can have a zero duration.
The structure therefore contains an index in addition to the date.
The index of the first access to a date is 0. Then the index is incremented as long as the date is not changed.
*/
struct STimeInd{
	PyTime m_Time;//!<\~french Date de la mmorisation\~english Date of storage
	unsigned m_Ind;//!<\~french Indice de la mmorisation  la date m_Time\~english Index of memorization at date m_Time
	/**\~french Construit un instant de mmorisation de date \p time et d'indice \p ind\~english Constructs a date memory instant \p time and index \p ind*/
	STimeInd(PyTime time=0,unsigned ind=0):m_Time(time),m_Ind(ind){}
	/**\~french Oprateur de comparaison d'instants de mmorisation.
	retourne vrai si l'instant courant prcde l'instant ti
	\~english Storage instant comparison operator.
	returns true if the current instant precedes instant ti
	*/
	bool operator<(STimeInd const&ti)const{return (m_Time!=ti.m_Time)?m_Time<ti.m_Time:((int)m_Ind<(int)ti.m_Ind);}
};

#define	CLRV(ptr,val)		(void)memset((ptr),(val),sizeof(*(ptr)))
#define	CLR(ptr)		    CLRV((ptr),0)
#define	CLRTV(tab,nb,val)	(void)memset((tab),(val),sizeof((tab)[0])*(nb))
#define	CLRT(tab,nb)		CLRTV(tab,nb,0)

#define FOR_EACH(IT,STOCK) for(auto IT=STOCK.begin();IT!=STOCK.end();IT++)

//Dfinitions de portabilit
int exists(char const*path);//Retourne 1 si existe, 2 si lisible, 3 si modifiable ngatif si rpertoire
char*strdupl(char const*str);//Duplique la chane de caractres (utilise new)
bool rm_file(char const*path);//Supprime le fichier

#ifdef WIN32
	#ifndef _MSC_VER
		//On est sous MinGW
		#include <string.h>
		#define NOEXCEPT noexcept
	#else
		#define NOEXCEPT
		#ifndef _CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES
			#define _CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES 1
			#define _CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES_COUNT 1
			#define _CRT_SECURE_CPP_OVERLOAD_SECURE_NAMES 1
			#define _CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES_MEMORY 1
		#endif
	#endif

	typedef void*   EventHandle ;
	typedef void*   MutexHandle ;
	typedef void*   ThreadHandle ;
	typedef void*   ProcessId ;
	typedef void*   FileId ;
	#define DIR_SEP_STR "\\"
	#define DIR_SEP_CHR '\\'
	#ifndef S_ISREG
		#define S_ISREG(B) ((B)&_S_IFREG)
		#define S_ISDIR(B) ((B)&_S_IFDIR)
	#endif
	int setenv(char const*var,char const*val,int owr);
	int unsetenv(char const*var);
	#ifndef va_copy
	#define va_copy(d,s) ((d) = (s))
	#endif
	void toConsole(char*text);
	void console1252();
#else
	#include <unistd.h>
	#include <pthread.h>
	typedef bool FBOOL ;
	struct TEvent{
		pthread_cond_t hevent;
		pthread_mutex_t mutex;
		};
	typedef struct TEvent* EventHandle ;
	typedef pthread_mutex_t* MutexHandle ;
	typedef pthread_t   ThreadHandle ;
	typedef pid_t     ProcessId ;
	typedef int         FileId ;
	#define __cdecl
	#define	__stdcall
	#define _atoi64 atoll
	#define _access access
	#define _finite finite
	#define _unlink unlink
	#define _hypot hypot
	#define _gcvt gcvt
	#define INVALID_HANDLE_VALUE 0
	#define _stat stat
	#define _isnan(val) std::isnan(val)
	#define _mkdir(dir) mkdir(dir,777)
	#define _getpid getpid
	#define _stricmp strcasecmp
	#define _fullpath(a,b,c) realpath(b,a)
	#define _makepath(a,b,c,d,e) makepath(a,c,d,e)
	#define _splitpath(f,d,dir,name,ext) splitpath(f,d,dir,name,ext)
	#define _chdir chdir
	#define _getcwd getcwd
	#define _sleep sleep
	#define _copysign copysign
	#define LoadLibrary(name) dlopen(name,RTLD_LAZY|RTLD_GLOBAL)
	#define FreeLibrary(h) dlclose(h)
	#define HMODULE void*
	#define GetProcAddress(h,n) dlsym(h,n)
	#define DIR_SEP_STR "/"
	#define DIR_SEP_CHR '/'
	#define NOEXCEPT noexcept
	void makepath(char*dest,char const*dir,char const*file,char const*ext);
	void splitpath(char const*filepath,char*disk,char*dir,char*file,char*ext);
	char*_strlwr(char*text);
	inline void toConsole(char*text){}
#endif

//Procdure de gestion des noms de fichiers
char*dir_sep(char*path);
char*canonicalFilePath(char*canonicalFilePath,char const*filePath);

#define VIRGULE ,

#ifndef _MAX_PATH
#define _MAX_PATH   4096
#define _MAX_DRIVE  3
#define _MAX_DIR    512
#define _MAX_EXT    256
#define _MAX_FNAME  256
#endif

#endif
