/*************************************
*         Copyright 2015 EDF         *
*************************************/
#pragma once
/**\file
\~french Fichier de dfinition de l'interface IFunctionalMockupUnit de manipulation des FMU.
\~english Definition file for the IFunctionalMockupUnit interface for manipulating FMUs.
*/

class CSystem;
class CSystemP;
class CPDMPManager;
class CSystemState;
class IVariable;
struct SPDMPSequence;
#include "Interfaces.h"

struct PYC_PUBLIC TFMUTrace{
	enum EFMUTrace{
		none,
		management,
		step,
		state=4
	};
};

/**\~french Classe de manipulation d'un FMU.
Cette classe permet de manipuler le contenu d'un FMU charg par PyCATSHOO.
Le FMU doit tre charg par appel de la fonction CSyste::addFMU.
Il est possible d'accder au variables exposes par le FMU sous une forme analogue  celle des variables PyCATSHOO.
Si l'unit de temps du FMU est diffrente de celle de la simulation PyCATSHOO, il est possible d'tablir la correspondance grce  la mthode setTimeRatio.

exemple:
\~english Class for handling an FMU.
This class allows manipulation of the content of an FMU loaded by PyCATSHOO.
The FMU must be loaded by calling the function CSyste::addFMU.
It is possible to access the variables exposed by the FMU in a manner similar to PyCATSHOO variables.
If the time unit of the FMU differs from that of the PyCATSHOO simulation, the correspondence can be established using the setTimeRatio method.

example:
\~
~~~~{.cpp}
class CComp:public CComponent{
	IVariable*path;
public:
	CComp(char const*name,CSystem&sys):CComponent(name,sys),path(addVariable("path",TVarType::t_string,"")){
		IFunctionalMockupUnit*FMU = sys.addFMU(path->sValue().c_str(),name);//Load the FMU indicated by path (We suppose here that path is a pre-parameterized variable)
		if(!FMU)
			ILogManager::glLogManager().throwError();
		IPDMPManager*pdmp=NULL;
		IPDMPManager*pdmp=sys.addPDMPManager("ODE");
		pdmp->addFMU(FMU);//Tell the PDMP manager that the FMU must follow time evolution during integration
		pdmp->addExplicitVariable(sys.FMU(name)->variable("h"));
	}
~~~~
*/
class PYC_PUBLIC IFunctionalMockupUnit: public CNamedComp{
	friend class CSystem;
	friend class CSystemP;
	friend class CPDMPManager;
	friend class CSystemState;
	friend struct SPDMPSequence;
	virtual bool load(char const*)=0;
	virtual bool startSimulation()=0;
	virtual bool stopSimulation()=0;
	virtual bool doStepTo(double time)=0;
	virtual void updateForSensitiveMethods()=0;
	virtual void update(int forceMonitoring=0)=0;//!<\~french Met  jour les variables et effectue le monitoring\~english Updates the variables and performs monitoring.
	virtual bool reset()=0;
	virtual bool canGetAndSetFMUState()const=0;
	virtual void*getCurrentState()const=0;//!<\~french Retourne une sauvegarde de l'tat du FMU\~english Returns a snapshot of the FMU's state.
	virtual bool freeCurrentState(void*st)=0;//!<\~french Libre l'tat st ou l'tat interne si st==NULL\~english Frees the state st or the internal state if st == NULL.
	virtual bool saveCurrentState()=0;//!<\~french Sauvegarde l'tat du FMU en interne\~english Saves the FMU's state internally.
	virtual bool resetCurrentState(void*st=NULL, PyTime time=0)=0;//!<\~french Replace le FMU dans l'tat fourni ou dans l'tat sauvegard en interne si st==NULL\~english Replaces the FMU in the provided state or in the internally saved state if st == NULL.
	virtual PyTime time()const=0;//!<\~french Retourne l'instant simulation courant du FMU\~english Returns the current simulation instant of the FMU.
	virtual PyTime memTime()const=0;//!<\~french Retourne l'instant de mmorisation de l'tat interne\~english Returns the instant of the internal state snapshot.
	static IFunctionalMockupUnit*newInstance(CSystem&system,char const*name);//!<\~french Construit une nouvelle instance de FMU\~english Creates a new instance of the FMU.
	static std::vector<std::string>loadedFMUs();//!<\~french Retourne la liste des FMU chargs\~english Return the liste of loaded FMUs.
protected:
	IFunctionalMockupUnit(CSysNamedComp&system,char const*name):CNamedComp(system,name){}
	virtual ~IFunctionalMockupUnit(){}
public:
	virtual void setTrace(int trace)=0;
	virtual int trace()const=0;
	virtual char const*modelName()const=0;//!<\~french Retourne le nom du modle gr par le FMU\~english Returns the name of the model managed by the FMU.
	virtual bool hasVariable(char const*name)const=0;//!<\~french Retourne vrai si la variable de nom name est connue du FMU\~english Returns true if the variable named name is known by the FMU.
	virtual IVariable*variable(char const*name)const=0;//!<\~french Retourne la variable de nom name\~english Returns the variable named name.
	virtual IVariable*renamedVariable(char const*name)const=0;//!<\~french Retourne la variable de nom d'origine ou nouveau name\~english Returns the variable with the original name or the new name.
	virtual bool setTimeRatio(double ratio)=0;//!<\~french Modifie le rapport entre tempts FMU et temps Pycatshoo\~english Modifies the ratio between FMU time and PyCATSHOO time.
	virtual void renameVariable(char const*name,char const*newName)=0;//!<\~french Renomme une variable du FMU\~english Renames a variable of the FMU.
	virtual std::vector<IVariable*> variables()const=0;//!<\~french Retourne les variables de la FMU\~english Returns the variables of the FMU.
	virtual std::vector<IVariable*> variables(char const *name, TVarType::EVarType * type = NULL)const=0;//!<\~french Retourne les variables de la FMU de nom matchant avec name et de type type si non NULL\~english Returns the variables of the FMU with names matching name and of type type if not NULL.
};