/*************************************
*         Copyright 2015 EDF         *
*************************************/
#pragma once

#include "Global.h"

#include <complex>

#ifdef _MSC_VER //Dsactivation du warning 'this': utilis dans la liste des initialiseurs membre de base
#pragma warning (disable : 4355)
#endif

struct _object;
typedef struct _object PyObject;
class CSystem;
class IEquation;
class IInequality;
class ISystemState;
class ISequence;
class CMethod;

/*\~french Classe de base de l'ensemble des composants nomms intervenant toujours directement dans un systme.

 Il n'y a pas de parent.
 Ces lments sont actuellement les systmes, les indicateurs et les cibles.
 \~english Base class of all named components that always directly intervene in a system.

There is no parent.
These elements are currently systems, indicators and targets.
*/
class PYC_PUBLIC CSysNamedComp
{
	CSystem*m_System;//!<\~french Systme contenant l'lment\~english System including the item
	char*m_Basename;//!<\~french Nom local de l'lment\~english Local name of the item
	char*m_Description;//!<\~french Description de l'lment\~english Description of the item
protected:
	virtual bool verify(){return true;}//!<\~french Mthode de vrification de l'lment appele en dbut de simulation\~english 
	CSysNamedComp():m_System(NULL),m_Basename(NULL),m_Description(NULL){}//!<\~french Construit un composant sans nom (constructeur de secours pour permettre des messages d'erreur\~english 
	CSysNamedComp(CSystem&system,char const*name);//!<\~french Construit un composant de nom name directement dans le systme\~english 
	virtual ~CSysNamedComp(void){delete[]m_Basename;}
	void setSystem(CSystem*system){m_System=system;}
	virtual void updateName(){}
public:
	static void checkMethodAddrSize(unsigned size);
	char const*basename()const{return m_Basename;}//!<\~french Retourne le nom de base de l'lment\~english Return the base name of the item
	virtual void setBasename(char const*bName);//!<\~french Modifie le nom de base de l'lment\~english Changes the base name of the item
	virtual char const*name()const{return m_Basename;}//!<\~french Retourne le nom complet de l'lment\~english Return the complete name of the item
	virtual bool hasBasename(char const* basename)const;//!<\~french Retourne vrai si le nom de base de l'lment est bName\~english Return true if the base name of the item is bName
	void setDescription(char const*description);//!<\~french Modifie la description du composant\~english Change the description of the item
	char const*description()const{return m_Description;}//!<\~french Retourne la description du composant\~english Return the description of the item
	CSystem&system()const{return*m_System;}//!<\~french Retourne le systme incluant l'lment\~english Return the system including the item
	PyTime currentTime()const;//!<\~french Retourne l'instant courant de simulation\~english Return the current instant of simulation
	bool isRunning()const;//!<\~french Retourne vrai si la simulation est en cours\~english Return true if the simulation is running
	bool isODESolving()const;//!<\~french Retourne vrai si une rsolution d'ODE est en cours\~english Return true if a ODE resolution is running
	int compare(CSysNamedComp const& other)const;//!<\~french Comparaison en fonction du nom\~english Comparator based upon name
	virtual void callPyMethod(char const* name, PyObject* pVoid)const {}
	virtual void callPyMethod(char const* name, PyObject* pVoid, char const* arg)const {}
	virtual std::complex<double>callCPyFunction(char const* name, PyObject* pVoid)const { return 0; }
	virtual double callDPyFunction(char const* name, PyObject* pyObj, ISystemState& ss1, ISystemState& ss2)const { return 0; }
	virtual double callDPyFunction(char const* name, PyObject* pVoid, double val)const { return 0; }
	virtual double callDPyFunction(char const* name, PyObject* pVoid)const { return 0; }
	virtual float callFPyFunction(char const* name, PyObject* pVoid)const { return 0; }
	virtual int callIPyFunction(char const* name, PyObject* pVoid)const { return 0; }
	virtual bool callBPyFunction(char const* name, PyObject* pVoid)const { return 0; }
	virtual bool callBPyFunction(PyObject* pVoid, float val)const { return false; }
	virtual char const* callSPyFunction(char const* name, PyObject* pVoid)const { return ""; }
	virtual void callPyEquation(char const* name, PyObject* pVoid, IEquation& equ)const { ; }
	virtual void callPyInequality(char const* name, PyObject* pVoid, IInequality& equ)const { ; }
	virtual bool callPySeqFilter(char const* name, PyObject* pVoid, ISequence const& seq)const { return false; }
	virtual CMethod* method(char const* name, void(CSysNamedComp::* method)());
	virtual CMethod* method(char const* name, PyObject* pyObj);
};

/*\~french Classe de base de l'ensemble des composants nomms intervenant dans un systme
 La classe maintient une relation avec son parent.
 \~english Base class of all named components involved in a system
The class maintains a relationship with its parent.
*/
class PYC_PUBLIC CNamedComp: public CSysNamedComp
{
	CNamedComp*m_Parent;//!<\~french Composant parent de l'lment\~english Parent component
	char*m_Name;//!<\~french Nom complet de l'lment\~english Complete name
	CNamedComp(CNamedComp const&){}//!<\~french Interdit de copier\~english Forbidden to copy
	CNamedComp const&operator=(CNamedComp const&){return*this;}//!<\~french Interdit de copier\~english Forbidden to copy
protected:
	CNamedComp() :m_Parent(NULL), m_Name(NULL) {}
	CNamedComp(CSysNamedComp&parent,char const*name);//!<\~french Construit un composant de nom name directement dans le parent qui peut tre un composant ou le systme\~english Constructs a component of name name directly in the parent which can be a component or the system
	virtual ~CNamedComp(void){delete[]m_Name;}
public:
	char const*levelName(unsigned level)const;//!<\~french Retourne le nom  l'intrieur du \p level ime composant\~english Returns the name inside the \p level ith component
	char const*name()const override{return m_Name;}//!<\~french Retourne le nom compos du composant construit en cumulant les noms des parents spars par des '.'\~english Returns the compound name of the component constructed by accumulating the names of the parents separated by '.'
	char const*parentName()const{return m_Parent?m_Parent->name():NULL;}
	static void verifyBasename(char const* bn);//!<\~french Lance une exception si le nom ne peut pas tre utilis comme nom de base\~english Throws an exception if the name cannot be used as a base name
	virtual void verifyBasename()const;
	virtual void updateName()override;//!<\~french Met  jour le nom aprs modification du nom de base ou des parents\~english 
	CNamedComp*parent()const{return m_Parent;}//!<\~french Retourne le parent du composant\~english 
	bool operator<(CNamedComp const&other)const;//!<\~french Comparaison en fonction du nom\~english 
	/**\~french Retourne les noms terminaux du nom compos \p name ou bien tout le nom terminal si \p all=vrai.
	\param name nom compos dont on souhaite le premier nom
	\param[out] fName contient en sortie le premier nom ou tous les premiers noms si all=vrai.
	\param all si vrai \p fName contient \p name dont on a ot le dernier nom
	\~english Returns the terminal names of the compound name \p name or the entire terminal name if \p all=true.
	\param name compound name whose first name is desired
	\param[out] fName contains the first name or all first names if all=true.
	\param all if true \p fName contains \p name whose last name has been removed
	*/
	static char const*firstName(char const*name,char*fName,bool all=false);
	/**\~french Retourne le nom du composant pour les vecteurs ordonns\~english Returns the component name for ordered vectors*/
	template<typename TYPE>static char const*const&ptrName(TYPE*const&c){return c->name();}
};

