/*************************************
*         Copyright 2015 EDF         *
*************************************/
#pragma once

#include "Interfaces.h"

#include <boost/python/object.hpp>

/*\~french Classe de gestion du GIL python\~english Class for managing the Python GIL.*/
class CPyGIL{
	PyGILState_STATE m_State;
public:
	CPyGIL():m_State(PyGILState_Ensure()){}
	~CPyGIL(){
		PyGILState_Release(m_State);
	}
};
class CPyNoGIL{
	PyThreadState*m_State;
public:
	CPyNoGIL():m_State(PyEval_SaveThread()){}
	~CPyNoGIL(){
		PyEval_RestoreThread(m_State);
	}
};

/*\~french Classe de gestion des objets python.
La classe prend une rfrence  la construction et la relche  la destruction.
\~english Class for managing Python objects.
The class takes a reference upon construction and releases it upon destruction.*/
class CPyObject{
protected:
	PyObject*m_PyObj;
	explicit CPyObject(PyObject*pyFonct):m_PyObj(NULL){set(pyFonct);}
	~CPyObject(){if(m_PyObj)Py_DECREF(m_PyObj);}
public:
	void set(PyObject*pyFonct){
		CPyGIL l_GIL;
		if(m_PyObj)
			Py_DECREF(m_PyObj);
		if(pyFonct && pyFonct!=Py_None)
			Py_INCREF(pyFonct);
		m_PyObj=pyFonct;
	}
	bool isNull()const{return m_PyObj==NULL;}
};
/*\~french Classe de gestion d'un fonctor condition sur un flottant pour l'analyseur, les squences et les rfrences\~english Class for managing a condition functor on a float for the parser, sequences, and references.*/
class CPyCondFctFloat:public ICondFctFloat,public CPyObject{
	CPyCondFctFloat(CPyCondFctFloat const&);
	CPyCondFctFloat&operator=(CPyCondFctFloat const&);
public:
	explicit CPyCondFctFloat(PyObject*pyFonct=NULL):CPyObject(pyFonct){}
	bool operator()(float val)const override{
		CPyGIL l_GIL;
		return boost::python::call<bool>(m_PyObj,val);
	}
};
