<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema">
	<xsl:template name="BRANCHES">
		<tbody>
			<xsl:for-each select="BR">
				<xsl:if test="position() =1">
					<tr align="center" valign="middle">
						<td rowspan="2" valign="middle" width="30px">n°</td>
						<td rowspan="2" width="100px">Date moyenne de fin</td>
						<td colspan="4">Description de la transition</td>
					</tr>
					<tr align="center" valign="middle">
						<td>nom</td>
						<td width="100px">état final</td>
						<td width="30px">type</td>
						<td width="35px">loi</td>
					</tr>
				</xsl:if>
				<tr>
					<td align="center" valign="middle">
						<xsl:value-of select="position()"/>
					</td>
					<td valign="center">
						<xsl:value-of select="@T"/>
					</td>
					<td valign="middle">
						<xsl:for-each select="TR">
							<xsl:value-of select="@NAME"/>
							<br/>
						</xsl:for-each>
					</td>
					<td valign="middle">
						<xsl:for-each select="TR">
							<xsl:value-of select="@ST"/>
							<br/>
						</xsl:for-each>
					</td>
					<td valign="middle">
						<xsl:for-each select="TR">
							<xsl:choose>
								<xsl:when test="@TT = '1'">tr</xsl:when>
								<xsl:when test="@TT = '2'">def</xsl:when>
								<xsl:when test="@TT = '3'">rep</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@TT"/>
								</xsl:otherwise>
							</xsl:choose>
							<br/>
						</xsl:for-each>
					</td>
					<td valign="middle">
						<xsl:for-each select="TR">
							<xsl:value-of select="@TD"/>
							<br/>
						</xsl:for-each>
					</td>
				</tr>
			</xsl:for-each>
		</tbody>
	</xsl:template>
	<xsl:template match="SEQ">
		<xsl:param name="NS"/>
		<tr>
			<xsl:if test="@ID">
				<xsl:attribute name="id"><xsl:value-of select="@ID"/>seq</xsl:attribute>
			</xsl:if>
			<td align="center" valign="middle">
				<xsl:if test="$NS=0 and @P">
					<xsl:value-of select="@P"/>
				</xsl:if>
				<xsl:if test="not($NS=0 and @P)">
					<xsl:value-of select="@N div $NS"/>
				</xsl:if>
			</td>
			<td align="center" valign="middle">
				<xsl:if test="@C">
					<xsl:value-of select="@C"/>
				</xsl:if>
				<xsl:if test="not(@C)">
					Tronquée
				</xsl:if>
			</td>
			<xsl:if test="@ID">
				<td>
					<xsl:value-of select="@ID"/>
				</td>
			</xsl:if>
			<td>
				<xsl:attribute name="colspan"><xsl:choose><xsl:when test="SEQ">2</xsl:when><xsl:otherwise>1</xsl:otherwise></xsl:choose></xsl:attribute>
				<table border="1" width="100%">
					<xsl:call-template name="BRANCHES"/>
				</table>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="/">
		<html>
			<head>
				<META http-equiv="Content-Type" content="text/html; charset=UTF-16"/>
			</head>
			<body>
				<xsl:for-each select="PYCRS">
					<xsl:variable name="NS" select="@NS"/>
					<xsl:variable name="NSF" select="@NSF"/>
					<p>Nombre de séquences tirées :
						<xsl:value-of select="@NS"/>
					</p>
					<p>Nombre de séquences filtrées :
						<xsl:value-of select="@NSF"/>
					</p>
					<p>Nombre de séquences regroupées :
						<xsl:value-of select="count(SEQ)"/>
					</p>
					<xsl:if test="TR_CL">
						<p>Classes de transitions</p>
						<table border="1" width="100%">
							<thead>
								<tr align="center" valign="middle">
									<td align="center" valign="middle">Nom de la classe</td>
									<td align="center" valign="middle">Nom des transitions</td>
									<td align="center" valign="middle">Indices de sortie</td>
								</tr>
							</thead>
							<tbody>
								<xsl:for-each select="TR_CL">
									<tr>
										<td>
											<xsl:value-of select="@NAME"/>
										</td>
										<td>
											<xsl:for-each select="TR">
												<xsl:if test="position()>1">
													<br/>
												</xsl:if>
												<xsl:value-of select="@NAME"/>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="TR">
												<xsl:if test="position()>1">
													<br/>
												</xsl:if>
												<xsl:value-of select="@IND"/>
											</xsl:for-each>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
					</xsl:if>
					<xsl:variable name="WithId" select="SEQ_CL"/>
					<xsl:if test="$WithId">
						<p>Classes de séquences</p>
						<table border="1" width="100%">
							<thead>
								<tr align="center" valign="middle">
									<td align="center" valign="middle">Définition de la classe</td>
									<td align="center" valign="middle">Indices des transitions groupées</td>
									<td align="center" valign="middle">Nombre de transitions</td>
								</tr>
							</thead>
							<tbody>
								<xsl:for-each select="SEQ_CL">
									<tr>
										<td>
											<xsl:value-of select="@NAME"/>
											<br/>Nombre séquences 
											<xsl:value-of select="@N"/>
											<br/>Filtre 
											<xsl:choose>
												<xsl:when test="@PAT">
													<xsl:value-of select="@PAT"/>
												</xsl:when>
												<xsl:when test="@OBJ">
													<xsl:value-of select="@OBJ"/>A t=
													<xsl:value-of select="@TIME"/> on a (
													<xsl:value-of select="@TYPE"/>)
													<xsl:value-of select="@OP"/>
													<xsl:value-of select="@VAL"/>
												</xsl:when>
											</xsl:choose>
										</td>
										<td>
											<xsl:for-each select="SEQ">
												<xsl:if test="position()>1">
													<br/>
												</xsl:if>
												<a>
													<xsl:attribute name="href">#<xsl:value-of select="@ID"/>seq</xsl:attribute>
													<xsl:value-of select="@ID"/>
												</a>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="SEQ">
												<xsl:if test="position()>1">
													<br/>
												</xsl:if>
												<xsl:value-of select="@N"/>
											</xsl:for-each>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
					</xsl:if>
					<table border="1" width="100%">
						<thead>
							<tr align="center" valign="middle">
								<td align="center" valign="middle">Proba séquence</td>
								<td align="center" valign="middle">Cause&#160;de&#160;l&apos;arrêt de la séquence</td>
								<xsl:if test="$WithId">
									<td align="center" valign="middle">Id séquence</td>
								</xsl:if>
								<td width="100%">Description des branches de la séquence</td>
							</tr>
						</thead>
						<tbody>
							<xsl:for-each select="SEQ">
								<xsl:apply-templates select=".">
									<xsl:with-param name="NS" select="$NS"/>
								</xsl:apply-templates>
								<xsl:if test="SEQ">
									<tr>
										<td colspan="4">
											<table border="1" width="100%">
												<thead>
													<tr align="center" valign="middle">
														<td align="center" valign="middle">Proba séquence</td>
														<td align="center" valign="middle">Cause&#160;de&#160;l&apos;arrêt de la séquence</td>
														<td align="center" valign="middle">Id séquence</td>
														<td width="100%">Description des branches de la séquence</td>
													</tr>
												</thead>
												<tbody>
													<xsl:for-each select="SEQ">
														<xsl:apply-templates select=".">
															<xsl:with-param name="NS" select="$NS"/>
														</xsl:apply-templates>
														<xsl:if test="SEQ">
														</xsl:if>
													</xsl:for-each>
												</tbody>
											</table>
										</td>
									</tr>
								</xsl:if>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:for-each>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
