<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema">
	<xsl:template name="BRANCHES">
		<tbody>
			<xsl:for-each select="BR">
				<xsl:if test="position() =1">
					<tr align="center" valign="middle">
						<td rowspan="2" valign="middle" width="30px">n°</td>
						<td rowspan="2" width="100px">Mean time of firing</td>
						<td colspan="4">Transition description</td>
					</tr>
					<tr align="center" valign="middle">
						<td>name</td>
						<td width="100px">final state</td>
						<td width="30px">type</td>
						<td width="35px">law</td>
					</tr>
				</xsl:if>
				<xsl:if test="sum(number(TR/@TT='2'))>0">
				<tr>
					<td align="center" valign="middle">
						<xsl:value-of select="position()"/>
					</td>
					<td valign="center">
						<xsl:value-of select="@T"/>
					</td>
					<td valign="middle">
						<xsl:for-each select="TR[@TT='2']">
							<xsl:value-of select="@NAME"/>
							<br/>
						</xsl:for-each>
					</td>
					<td valign="middle">
						<xsl:for-each select="TR[@TT='2']">
							<xsl:value-of select="@ST"/>
							<br/>
						</xsl:for-each>
					</td>
					<td valign="middle">
						<xsl:for-each select="TR[@TT='2']">
							<xsl:choose>
								<xsl:when test="@TT = '1'">tr</xsl:when>
								<xsl:when test="@TT = '2'">flt</xsl:when>
								<xsl:when test="@TT = '3'">rep</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@TT"/>
								</xsl:otherwise>
							</xsl:choose>
							<br/>
						</xsl:for-each>
					</td>
					<td valign="middle">
						<xsl:for-each select="TR[@TT='2']">
							<xsl:value-of select="@TD"/>
							<br/>
						</xsl:for-each>
					</td>
				</tr>
				</xsl:if>
			</xsl:for-each>
		</tbody>
	</xsl:template>
	<xsl:template match="SEQ">
		<xsl:param name="NS"/>
		<tr>
			<xsl:if test="@ID">
				<xsl:attribute name="id"><xsl:value-of select="@ID"/>seq</xsl:attribute>
			</xsl:if>
			<td align="center" valign="middle">
				<xsl:if test="$NS=0 and @P">
					<xsl:value-of select="@P"/>
				</xsl:if>
				<xsl:if test="not($NS=0 and @P)">
					<xsl:value-of select="@N div $NS"/>
				</xsl:if>
			</td>
			<td align="center" valign="middle">
				<xsl:if test="@C">
					<xsl:value-of select="@C"/>
				</xsl:if>
				<xsl:if test="not(@C)">
					Truncated
				</xsl:if>
			</td>
			<xsl:if test="@ID">
				<td>
					<xsl:value-of select="@ID"/>
				</td>
			</xsl:if>
			<td>
				<xsl:attribute name="colspan"><xsl:choose><xsl:when test="SEQ">2</xsl:when><xsl:otherwise>1</xsl:otherwise></xsl:choose></xsl:attribute>
				<table border="1" width="100%">
					<xsl:call-template name="BRANCHES"/>
				</table>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="/">
		<html>
			<head>
				<META http-equiv="Content-Type" content="text/html; charset=UTF-16"/>
			</head>
			<body>
				<xsl:for-each select="PYCRS">
					<xsl:variable name="NS" select="@NS"/>
					<xsl:variable name="NSF" select="@NSF"/>
					<p>Number of simulated sequences :
						<xsl:value-of select="@NS"/>
					</p>
					<p>Number of filtered sequences :
						<xsl:value-of select="@NSF"/>
					</p>
					<p>Number of grouped sequences :
						<xsl:value-of select="count(SEQ)"/>
					</p>
					<xsl:if test="TR_CL">
						<p>Classes of transitions</p>
						<table border="1" width="100%">
							<thead>
								<tr align="center" valign="middle">
									<td align="center" valign="middle">Name of the class</td>
									<td align="center" valign="middle">Name of transitions</td>
									<td align="center" valign="middle">Output indexes</td>
								</tr>
							</thead>
							<tbody>
								<xsl:for-each select="TR_CL">
									<tr>
										<td>
											<xsl:value-of select="@NAME"/>
										</td>
										<td>
											<xsl:for-each select="TR">
												<xsl:if test="position()>1">
													<br/>
												</xsl:if>
												<xsl:value-of select="@NAME"/>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="TR">
												<xsl:if test="position()>1">
													<br/>
												</xsl:if>
												<xsl:value-of select="@IND"/>
											</xsl:for-each>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
					</xsl:if>
					<xsl:variable name="WithId" select="SEQ_CL"/>
					<xsl:if test="$WithId">
						<p>Classes of sequences</p>
						<table border="1" width="100%">
							<thead>
								<tr align="center" valign="middle">
									<td align="center" valign="middle">Definition of the class</td>
									<td align="center" valign="middle">Indexes of grouped transitions</td>
									<td align="center" valign="middle">Number of transitions</td>
								</tr>
							</thead>
							<tbody>
								<xsl:for-each select="SEQ_CL">
									<tr>
										<td>
											<xsl:value-of select="@NAME"/>
											<br/>Number of sequences 
											<xsl:value-of select="@N"/>
											<br/>Filter 
											<xsl:choose>
												<xsl:when test="@PAT">
													<xsl:value-of select="@PAT"/>
												</xsl:when>
												<xsl:when test="@OBJ">
													<xsl:value-of select="@OBJ"/>At t=
													<xsl:value-of select="@TIME"/> we have (
													<xsl:value-of select="@TYPE"/>)
													<xsl:value-of select="@OP"/>
													<xsl:value-of select="@VAL"/>
												</xsl:when>
											</xsl:choose>
										</td>
										<td>
											<xsl:for-each select="SEQ">
												<xsl:if test="position()>1">
													<br/>
												</xsl:if>
												<a>
													<xsl:attribute name="href">#<xsl:value-of select="@ID"/>seq</xsl:attribute>
													<xsl:value-of select="@ID"/>
												</a>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="SEQ">
												<xsl:if test="position()>1">
													<br/>
												</xsl:if>
												<xsl:value-of select="@N"/>
											</xsl:for-each>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
					</xsl:if>
					<table border="1" width="100%">
						<thead>
							<tr align="center" valign="middle">
								<td align="center" valign="middle">Sequence probability</td>
								<td align="center" valign="middle">Sequence ending&#160;reason</td>
								<xsl:if test="$WithId">
									<td align="center" valign="middle">Sequence id</td>
								</xsl:if>
								<td width="100%">Description of sequence branches</td>
							</tr>
						</thead>
						<tbody>
							<xsl:for-each select="SEQ">
								<xsl:apply-templates select=".">
									<xsl:with-param name="NS" select="$NS"/>
								</xsl:apply-templates>
								<xsl:if test="SEQ">
									<tr>
										<td colspan="4">
											<table border="1" width="100%">
												<thead>
													<tr align="center" valign="middle">
														<td align="center" valign="middle">Sequence probability</td>
														<td align="center" valign="middle">Sequence ending&#160;reason</td>
														<td align="center" valign="middle">Sequence id</td>
														<td width="100%">Description of sequence branches</td>
													</tr>
												</thead>
												<tbody>
													<xsl:for-each select="SEQ">
														<xsl:apply-templates select=".">
															<xsl:with-param name="NS" select="$NS"/>
														</xsl:apply-templates>
														<xsl:if test="SEQ">
														</xsl:if>
													</xsl:for-each>
												</tbody>
											</table>
										</td>
									</tr>
								</xsl:if>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:for-each>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>