import Pycatshoo as Pyc
import sys, os
import zipfile
import shutil

class MySystem(Pyc.CSystem):
    def __init__(self, name):
        Pyc.CSystem.__init__(self, name)

    def construct(self):
        self.tank = self.newComponent("FMUTank","FMUTank")

if __name__ == '__main__':
    try:
        pycatshoo_dir = os.environ["PYCATSHOO_DIR"]

        Pyc.CSystem.loadKBLibrary(pycatshoo_dir + "/lib/libHeatedTankFMUGenerator.so")

        print("PyCATSHOO Version : ", Pyc.ILogManager.glLogManager().version())

        system = MySystem("libHeatedTankFMU")
        system.setPreAssignment(".NbInput", "3")
        system.construct()

        system.dumpFMUXML("fmuzip/modelDescription.xml", 3) # Création du fichier de description du FMU
        system.dumpParameters("fmuzip/resources/system.xml", False) # Création du fichier de paramétrage du système du FMU

        os.chdir("fmuzip")
        with zipfile.ZipFile("fmuzip.fmu", 'w') as zip :
            zip.write("modelDescription.xml")
            zip.write("resources/system.xml")
            if sys.platform == "win32":
                shutil.copy("{0}/libHeatedTankFMU.dll".format(pycatshoo_dir + "/lib"), "binaries/x86_64-windows")
                zip.write("binaries/x86_64-windows/libHeatedTankFMU.dll")
            elif sys.platform == "darwin":
                shutil.copy("{0}/libHeatedTankFMU.so".format(pycatshoo_dir + "/lib"), "binaries/aarch64-darwin/libHeatedTankFMU.dylib")
                zip.write("binaries/aarch64-darwin/libHeatedTankFMU.dylib")
            else:
                shutil.copy("{0}/libHeatedTankFMU.so".format(pycatshoo_dir + "/lib"), "binaries/x86_64-linux")
                zip.write("binaries/x86_64-linux/libHeatedTankFMU.so")

        with zipfile.ZipFile("fmuzip.fmu", 'r') as zip:
            zip.printdir()

        msg = Pyc.glLogManager().messages()
        if msg:
            print(msg)
    except Exception as e:
        print(type(e),e)
    sys.stdout.flush()

