# -*- coding: iso-8859-15 -*-
"""
Copyright EDF 2017
@author: Hassane CHRAIBI - hassane.chraibi@edf.fr
"""

from Util import *                                                                              #S1
from HeatedTank import *



class MySystem(Pyc.CSystem):                                                                    #S1
    def __init__(self, name):                                                                   #S1
        Pyc.CSystem.__init__(self, name)                                                        #S1

        self.P1   = Pump("P1")                                                                  #S1
        self.P2   = Pump("P2")                                                                  #S1
        self.V3   = Valve("V3")                                                                 #S2a
        self.tank = Tank("Tank")                                                                #S1
        self.fuel = Fuel("Fuel")                                                                #S7

        self.connect("P1"  , "Tank", "Tank", "Pump" )                                           #S1
        self.connect("P2"  , "Tank", "Tank", "Pump" )                                           #S1
        self.connect("V3"  , "Tank", "Tank", "Valve")                                           #S2a
        self.connect("Fuel", "Tank", "Tank", "Fuel" )                                           #S7




def mySequenceFilter(sequence):                                                                 #S8d
    ofElement = Pyc.CSystem.glSystem().monitoredElt("Tank.OverFlow"      , "ST")             #S8d
    doElement = Pyc.CSystem.glSystem().monitoredElt("Tank.DryOut"        , "ST")             #S8d
    htElement = Pyc.CSystem.glSystem().monitoredElt("Tank.HotTemperature", "ST")             #S8d

    return( sequence.value(ofElement, system.tMax()) == 1 or                                    #S8d
            sequence.value(doElement, system.tMax()) == 1 or                                    #S8d
            sequence.value(htElement, system.tMax()) == 1                                       #S8d
          )




if __name__ == '__main__':                                                                      #S1

    print("PyCATSHOO Version : ", Pyc.ILogManager.glLogManager().version())

    system = MySystem("HeatedTankSystem")                                                       #S1
    system.loadParameters("S8dHTBase.xml")                                                           #S1
    system.setRNGSeed(4536)                                                                     #S1

    system.setResultFileName("S8dHTBaseRes.xml", True)

    system.addTarget("HotTemperature", "Tank.HotTemperature", "ST")                             #S8c
    system.addTarget("OverFlow"      , "Tank.OverFlow"      , "ST")                             #S8c
    system.addTarget("DryOut"        , "Tank.DryOut"        , "ST")                             #S8c


    system.addInstants(0, system.tMax(), 100)                                                   #S8c


    ofIndicator = system.addIndicator("Overflow", "Tank.OverFlow", "ST")                        #S8c
    ofIndicator.setRestitutions(Pyc.TIndicatorType.mean_values)                                     #S8c

    doIndicator = system.addIndicator("DryOut", "Tank.DryOut", "ST")                          #S8c
    doIndicator.setRestitutions(Pyc.TIndicatorType.mean_values)                                 #S8c


    htIndicator = system.addIndicator("HotTemp", "Tank.HotTemperature", "ST")                   #S8c
    htIndicator.setRestitutions(Pyc.TIndicatorType.mean_values)                                 #S8c



    system.setSeqFilter(mySequenceFilter)                                                       #S8d
    system.setKeepFilteredSeqForInd(True)                                                       #S8d

    tb = time.time()                                                                            #S1
    system.simulate()                                                                           #S1

    if system.MPIRank() > 0 :
        exit(0)

    te=time .time()                                                                             #S1
    sTime = te-tb                                                                               #S1
    print ("Simulation time ", sTime )                                                          #S1

    meanOVF = ofIndicator.means()                                                               #S8c
    meanDO  = doIndicator.means()                                                               #S8c
    meanHT  = htIndicator.means()                                                               #S8c

    tps = system.instants()                                                                     #S8c


    plot(tps, True, True,                                                                      #S5 ==> S8a
            (                                                                                  #S1
                (("Tank"), "Time", "OverFlow", ((meanOVF, 'r-', 'Tank OverFlow'),)),           # S8a
                (("Tank"), "Time", "DryOut"  , ((meanDO , 'g-', 'Tank DryOut'  ),)),           # S8a
                (("Tank"), "Time", "Burnt"   , ((meanHT , 'b-', 'Tank Burnt'   ),)),           # S8a
            )                                                                                  #S1
         )                                                                                     #S1


    # analyzer = Pyc.CAnalyser(system)                                                           #S8d
    # if not analyzer.printFilteredSeq(10., "S8eHTBaseSeq.xml", "PycSeq.xsl"):                   #S8d
    #     Pyc.ILogManager.glLogManager().printMessages()                                         #S8d


