# coding: latin-1

'''
Created on 18 juin 2015

@author: H. CHRAIBI

@Copyright : EDF
'''


import Pycatshoo as Pyc
from matplotlib.pyplot import *

if sys.version_info.minor < 12:
    import imp
else :
    import importlib as imp

import time, __main__, os, json, datetime


def plot( tS, sameFigure, showFigure, ySS):
    
    if sameFigure :
        fig = figure()
        pilt = fig.add_subplot(111)
        
    for yS in ySS:
        if not sameFigure :
            fig = figure()
            pilt = fig.add_subplot(111)
            
        pilt.set_title(yS[0])  
    
        pilt.set_xlabel(yS[1])
        pilt.set_ylabel(yS[2])
        
        for y in yS[3] :
            if y[0] == None :
                continue
            pilt.plot(tS, y[0],y[1], label=y[2])
            pilt.legend(loc='best')
    
    if showFigure :
        show()
        

def instantsList(tMax, n):
    t0 = 0
    l = [0]
    for i in range(1, n) :
        l.append(t0 + i*tMax/n)
    
    l[n-1] = tMax
    
    return l
    
def stepsVector(tMax, steps):
    tp   = 0
    pas  = tMax/steps
    tps = Pyc.VectorDouble()
    while tp < tMax:
        tps.append(tp)
        tp += pas
    tps.append(tp)
    return tps

def PlotElementMeanValues (elementNameTuple, fractile, system, nTimeSteps, label, stop = True) :
    analyser = Pyc.CAnalyser(system)

    vectorOfInstants = stepsVector(system.tMax(), nTimeSteps)

    stdvValues = Pyc.VectorFloat()
    toPlot = ()



    for element in elementNameTuple :
        mv  = Pyc.VectorFloat()
        analyser.meanValues(element[0], vectorOfInstants, mv, stdvValues)
        toPlot = toPlot + (
                            (("%d Sequences") % system.nbSequences(),
                             "Time",
                             label,
                             ((mv, element[1], "Mean of " + element[0]),)),
                          )

        if fractile > 0 :
            fract01 = Pyc.VectorFloat()
            fract99 = Pyc.VectorFloat()
            analyser.quantiles(element[0], vectorOfInstants, fract01, fractile, fract99, fractile)
            toPlot = toPlot + (
                (("%d Sequences") % system.nbSequences(),
                 "Time",
                 label,
                 ((fract99, 'r', "Fractile %d%s > "%(1,'%') + " of " + element[0]),)),
            )
            toPlot = toPlot + (
                (("%d Sequences") % system.nbSequences(),
                 "Time",
                 label,
                 ((fract01, 'b', "Fractile %d%s < "%(1, '%') + " of " + element[0]),)),
            )


    plot(vectorOfInstants, True, stop,
         (
             toPlot
         )
         )

def PlotRealizedValues(elementNameTuple, operator, value,
                       system, nTimeSteps, label, stop=True):
    analyser = Pyc.CAnalyser(system)

    vectorOfInstants = stepsVector(system.tMax(), nTimeSteps)

    stdvValues = Pyc.VectorFloat()
    toPlot = ()

    for element in elementNameTuple:
        mv = Pyc.VectorFloat()
        #analyser.realized(element[0], vectorOfInstants, operator, value, mv)
        analyser.realized(element[0], vectorOfInstants, lambda x : x <= value, mv)
        toPlot = toPlot + (
            (("%d Sequences") % system.nbSequences(),
             "Time",
             label,
             ((mv, element[1], "CPDF of " + element[0]),)),
        )

    plot(vectorOfInstants, True, stop,
         (
             toPlot
         )
         )



def saveIndicatorsAsJson(fileName, instants, namedData):
    nPoints = len(instants)
    for nData in namedData:
        if len(nData[3]) != nPoints:
            return False

    data = {}
    data["PyCATSHOO Version"] = Pyc.ILogManager.glLogManager().version()
    data["File Name"] = os.path.basename(__main__.__file__)

    current_datetime = datetime.datetime.now()
    strDate =  str(current_datetime.day) + "/" + str(current_datetime.month) + "/" + str(current_datetime.year) + "-" + str(current_datetime.hour) + "h" + str(current_datetime.minute)
    data["Date"] = strDate
    data["Sequence Number"] = Pyc.CSystem.glSystem().nbSeqSim()
    data["Instant Number"]  = nPoints
    data["Instants"] = [t for t in instants]
    data["Data"] = {}
    for nData in namedData:
        k = nData[0]
        data["Data"][k] = {}

        data["Data"][k]["Attribute"] = nData[1]
        data["Data"][k]["Nature"]    = nData[2]
        data["Data"][k]["Values"]    = [v for v in nData[3]]

    with open(fileName, 'w') as file:
        json.dump(data, file)
        
      




